<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6"><h3 class="mb-0">Profile</h3></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                    <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Profile</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="app-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="col-lg-6 connectedSortable">
                    <div class="card mb-4">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <h3 class="card-title">Profile</h3>
                            </div>
                        </div>
                        <form name="f1" id="f1" action="<?=base_url()?>profile/update" method="post" enctype="multipart/form-data">
                        <div class="card-body">
                            <div class="form-group mb-3">
                                <label for="nominal" class="form-label">Email : </label>
                                <input type="email" class="form-control" id="email" name="email" value="<?=$data->email?>">
                                <span id="eemail" class="text-danger invalid-feedback"></span>
                            </div>
                            <div class="form-group mb-3">
                                <label for="nominal" class="form-label">Nama : </label>
                                <input type="text" class="form-control" id="username" name="username" value="<?=$data->nama?>">
                                <span id="eusername" class="text-danger invalid-feedback"></span>
                            </div>
                            <div class="form-group mb-3">
                                <label for="nominal" class="form-label">Level : </label>
                                <select name="group" class="form-control select2">
                                    <option value="<?=$data->level?>" selected><?=$data->level?></option>
                                </select>
                                <span id="egroup" class="text-danger invalid-feedback"></span>
                            </div>
                            <div class="form-group mb-3">
                                <label for="nominal" class="form-label">Password : </label>
                                <input type="password" class="form-control" id="password" name="password">
                                <span id="epassword" class="text-danger invalid-feedback"></span>
                            </div>
                            <div class="form-group mb-3">
                                <label for="nominal" class="form-label">Password Confirm : </label>
                                <input type="password" class="form-control" id="password_confirm" name="password_confirm">
                                <span id="epassword_confirm" class="text-danger invalid-feedback"></span>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert2') ?>
<?= $this->include('layout/js/sweetalert2') ?>

<?= $this->include('layout/css/select2') ?>
<?= $this->include('layout/js/select2') ?>

<script type="text/javascript">
$(document).ready(function () {
    $(".select2").select2({
         theme: 'bootstrap-5'
    });

    $("#f1").submit(function (e) {
        e.preventDefault();
        Swal.fire({
            text: 'Menyimpan data.. Silahkan tunggu..',
            allowOutsideClick: false
        });
        Swal.showLoading();
        
        var data_kirim = $("#f1").serializeArray();
        data_kirim.push({name : "id", value : "<?=$data->id_user?>"});

        $.post("<?=base_url()?>profile/update",data_kirim).done(function (data) {
            if (data.status == 'success')
            {
                Swal.fire({
                    text:'Data berhasil disimpan!',
                    icon : 'success'
                }).then(function () {
                    window.location.href = '<?=base_url()?>profile';
                });
            }
        }).fail(function (data) {
            if(data.statusText == 'input'){
                Object.keys(data.responseJSON.messages.error).forEach(function(key){
                    $("#e"+key).html(data.responseJSON.messages.error[key]);
                    $("#e"+key).show();
                });
                Swal.close();
            }else{
                if(data.error){
                    Swal.fire({
                        text:data.error,
                        icon : 'error'
                    });
                }else{
                    Swal.fire({
                        text:'Terjadi kesalahan sistem!',
                        icon : 'error'
                    });
                }
            }
        });
    });
});
</script>
<?= $this->endSection() ?>
