<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6"><h3 class="mb-0">Device</h3></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                    <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?=base_url()?>device">Device</a></li>
                    <li class="breadcrumb-item active" aria-current="page">View Device</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="app-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-6 connectedSortable">
                <div class="card mb-4">
                    <div class="card-header"><h3 class="card-title">View Device</h3></div>
                    <form name="f1" id="f1" action="<?=base_url()?>device/update" method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Name :</label>
                            <input type="text" class="form-control" id="name" name="name" value="<?=$data->serial_id?>">
                            <span id="ename" class="text-danger invalid-feedback"></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Serial ID :</label>
                            <input type="text" class="form-control" id="serial_id" name="serial_id" value="<?=$data->serial_id?>">
                            <span id="eserial_id" class="text-danger invalid-feedback"></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Model :</label>
                            <input type="text" class="form-control" id="model" name="model" value="<?=$data->model?>">
                            <span id="emodel" class="text-danger invalid-feedback"></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Mode :</label>
                            <select class="form-control select2" id="mode" name="mode">
                                <option value="API" <?=($data->mode == "API") ? "selected" : ""?>>API</option>
                                <option value="MQTT" <?=($data->mode == "MQTT") ? "selected" : ""?>>MQTT</option>
                                <option value="LORA" <?=($data->mode == "LORA") ? "selected" : ""?>>LORA</option>
                            </select>
                            <span id="emode" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Submit</button> <a href="#" id="btn_delete" class="btn btn-danger"><i class="mdi mdi-delete"></i> <span>Delete Data</span></a>
                    </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-6 connectedSortable">
                <div class="card mb-4">
                    <div class="card-header"><h3 class="card-title">Device Info</h3></div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Registered At :</label>
                            <span class="form-control"><?=$data->registered?></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Last Response :</label>
                            <span class="form-control"><?=$data->last_data?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert2') ?>
<?= $this->include('layout/js/sweetalert2') ?>

<?= $this->include('layout/css/select2') ?>
<?= $this->include('layout/js/select2') ?>

<script type="text/javascript">
$(document).ready(function () {
    $(".select2").select2({
         theme: 'bootstrap-5'
    });

    $("#f1").submit(function (e) {
        e.preventDefault();
        Swal.fire({
            text: 'Menyimpan data.. Silahkan tunggu..',
            allowOutsideClick: false
        });
        Swal.showLoading();
        
        var data_kirim = $("#f1").serializeArray();
        data_kirim.push({name : "id", value : "<?=$data->id_device?>"});

        $.post("<?=base_url()?>device/update",data_kirim).done(function (data) {
            if (data.status == 'success')
            {
                Swal.fire({
                    text:'Data berhasil disimpan!',
                    icon : 'success'
                }).then(function () {
                    window.location.href = '<?=base_url()?>device/view/<?=$data->id_device?>';
                });
            }
        }).fail(function (data) {
            if(data.statusText == 'input'){
                Object.keys(data.responseJSON.messages.error).forEach(function(key){
                    $("#e"+key).html(data.responseJSON.messages.error[key]);
                    $("#e"+key).show();
                });
                Swal.close();
            }else{
                if(data.error){
                    Swal.fire({
                        text:data.error,
                        icon : 'error'
                    });
                }else{
                    Swal.fire({
                        text:'Terjadi kesalahan sistem!',
                        icon : 'error'
                    });
                }
            }
        });
    });

    $("#btn_delete").click(function(e) {
        e.preventDefault();

        Swal.fire({
            title:'Delete Data..',
            html: '<p>Yakin ingin menghapus data ini?</p>',
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    text: 'Menghapus data.. Silahkan tunggu..',
                    allowOutsideClick: false
                });
                Swal.showLoading();
                $.post("<?=base_url()?>device/delete",{id:<?=$data->id_device?>}).done(function (data) {
                    if (data.status == 'success')
                    {
                        Swal.fire({
                            text:'Data berhasil dihapus!',
                            icon : 'success'
                        }).then(function () {
                            window.location.href = '<?=base_url()?>device';
                        });
                    }
                }).fail(function (data) {
                    Swal.fire({
                        text:'Terjadi kesalahan pada saat operasi delete!',
                        icon : 'error'
                    });
                });
            } else if (result.isDenied) {
                Swal.fire('Operasi dibatalkan..', '', 'info')
            }
        });
    });
});
</script>
<?= $this->endSection() ?>
