<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6"><h3 class="mb-0">Device</h3></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                    <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?=base_url()?>device">Device</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Device</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="app-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="col-lg-6 connectedSortable">
                    <div class="card mb-4">
                        <div class="card-header"><h3 class="card-title">Add New Device</h3></div>
                        <form name="f1" id="f1" action="<?=base_url()?>device/save_add" method="post" enctype="multipart/form-data">
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Name :</label>
                                <input type="text" class="form-control" id="name" name="name">
                                <span id="ename" class="text-danger invalid-feedback"></span>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Serial ID :</label>
                                <input type="text" class="form-control" id="serial_id" name="serial_id">
                                <span id="eserial_id" class="text-danger invalid-feedback"></span>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Model :</label>
                                <input type="text" class="form-control" id="model" name="model">
                                <span id="emodel" class="text-danger invalid-feedback"></span>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Mode :</label>
                                <select class="form-control select2" id="mode" name="mode">
                                    <option value="API">API</option>
                                    <option value="MQTT">MQTT</option>
                                    <option value="LORA">LORA</option>
                                </select>
                                <span id="emode" class="text-danger invalid-feedback"></span>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert2') ?>
<?= $this->include('layout/js/sweetalert2') ?>

<?= $this->include('layout/css/select2') ?>
<?= $this->include('layout/js/select2') ?>

<script type="text/javascript">
$(document).ready(function () {
    $(".select2").select2({
         theme: 'bootstrap-5'
    });

    $("#f1").submit(function (e) {
        e.preventDefault();
        Swal.fire({
            text: 'Menyimpan data.. Silahkan tunggu..',
            allowOutsideClick: false
        });
        Swal.showLoading();
        
        var data_kirim = $("#f1").serialize();

        $.post("<?=base_url()?>device/add_save",data_kirim).done(function (data) {
            if (data.status == 'success')
            {
                Swal.fire({
                    text:'Data baru berhasil disimpan!',
                    icon : 'success'
                }).then(function () {
                    window.location.href = '<?=base_url()?>device/add';
                });
            }
        }).fail(function (data) {
            if(data.statusText == 'input'){
                Object.keys(data.responseJSON.messages.error).forEach(function(key){
                    $("#e"+key).html(data.responseJSON.messages.error[key]);
                    $("#e"+key).show();
                });
                Swal.close();
            }else{
                if(data.error){
                    Swal.fire({
                        text:data.error,
                        icon : 'error'
                    });
                }else{
                    Swal.fire({
                        text:'Terjadi kesalahan sistem!',
                        icon : 'error'
                    });
                }
            }
        });
    });
});
</script>
<?= $this->endSection() ?>
