<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6"><h3 class="mb-0">Data Log</h3></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                    <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?=base_url()?>data">Data Log</a></li>
                    <li class="breadcrumb-item active" aria-current="page">View Data</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="app-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-6 connectedSortable">
                <div class="card mb-4">
                    <div class="card-header"><h3 class="card-title">Device Info</h3></div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Name :</label>
                            <span class="form-control"><?=$data->name?></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Serial ID :</label>
                            <span class="form-control"><?=$data->serial_id?></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Model :</label>
                            <span class="form-control"><?=$data->model?></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Mode :</label>
                            <span class="form-control"><?=$data->mode?></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 connectedSortable">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between">
                        <h3 class="card-title">Device Log</h3>
                        <a href="#" id="btn_delete" class="btn btn-sm btn-danger"><i class="mdi mdi-delete"></i> <span>Delete Data</span></a>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Temp :</label>
                            <span class="form-control"><?=$data->temp?></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Humidity :</label>
                            <span class="form-control"><?=$data->humid?></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">ADC :</label>
                            <span class="form-control"><?=$data->adc?></span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">PPM :</label>
                            <span class="form-control"><?=$data->ppm?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert2') ?>
<?= $this->include('layout/js/sweetalert2') ?>

<?= $this->include('layout/css/select2') ?>
<?= $this->include('layout/js/select2') ?>

<script type="text/javascript">
$(document).ready(function () {
    $(".select2").select2({
         theme: 'bootstrap-5'
    });

    $("#btn_delete").click(function(e) {
        e.preventDefault();

        Swal.fire({
            title:'Delete Data..',
            html: '<p>Yakin ingin menghapus data ini?</p>',
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    text: 'Menghapus data.. Silahkan tunggu..',
                    allowOutsideClick: false
                });
                Swal.showLoading();
                $.post("<?=base_url()?>data/delete",{id:<?=$data->id_data?>}).done(function (data) {
                    if (data.status == 'success')
                    {
                        Swal.fire({
                            text:'Data berhasil dihapus!',
                            icon : 'success'
                        }).then(function () {
                            window.location.href = '<?=base_url()?>data';
                        });
                    }
                }).fail(function (data) {
                    Swal.fire({
                        text:'Terjadi kesalahan pada saat operasi delete!',
                        icon : 'error'
                    });
                });
            } else if (result.isDenied) {
                Swal.fire('Operasi dibatalkan..', '', 'info')
            }
        });
    });
});
</script>
<?= $this->endSection() ?>
