<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<div class="app-content-header">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6"><h3 class="mb-0">Data Log</h3></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                    <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Data Log</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="app-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="col-lg-12 connectedSortable">
                    <div class="card mb-4">
                        <div class="card-header"><h3 class="card-title">Devices Logs</h3></div>
                        <div class="card-body">
                            <table id="tbl1" class="table table-striped table-bordered table-sm nowrap">
                                <thead>
                                    <tr>
                                        <th>No.</th>
                                        <th class="dt-filterable">Name</th>
                                        <th class="dt-filterable">Serial ID</th>
                                        <th class="dt-filterable">Model</th>
                                        <th class="dt-filterable">Temp</th>
                                        <th class="dt-filterable">Humid</th>
                                        <th class="dt-filterable">ADC</th>
                                        <th class="dt-filterable">PPM</th>
                                        <th class="dt-filterable">Time</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>  
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/datatables') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function () {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>device/ajax_dt',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'name' },
            { data: 'serial_id' },
            { data: 'model' },
            { data: 'temp' },
            { data: 'humid' },
            { data: 'adc' },
            { data: 'ppm' },
            { data: 'created_at' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 9,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><i class="mdi mdi-open-in-new"></i> View</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>datadevice/view/'+data['id_data'];
    });
});
</script>
<?= $this->endSection() ?>
