<?php
namespace App\Controllers\Admin;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Devicemodel;
use App\Models\Datadevicemodel;

class Datadevice extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/datadevice/index',$data);
    }

    public function ajax_dt(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Datadevicemodel();
        return $DataModel->GetDT($data_post,"");
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Datadevicemodel();
        
        $builder = $tmodel->builder("vdatadevice");
        $data['data'] = $builder->where("id_data",$id)->get()->getRow();

        return view('admin/datadevice/view',$data);
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        try{
            $tmodel = new Datadevicemodel();
            if ($tmodel->delete($id))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }catch(\Exception $e){
            return $this->fail(["error" => $e->getMessage()],400,null,'db');
        }
    }
}
?>