<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
// $routes->get('superadmin', 'Superadmin::index');

$routes->group('admin', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('home', 'Admin\Home::index');
});

$routes->group('device', ['filter' => 'group:admin, user'], static function ($routes) {
    $routes->get('/', 'Admin\Device::index');
    $routes->post('ajax_dt', 'Admin\Device::ajax_dt');
    $routes->group('', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('add', 'Admin\Device::add');
        $routes->post('add_save', 'Admin\Device::add_save');
        $routes->post('update', 'Admin\Device::update');
        $routes->post('delete', 'Admin\Device::delete');
    });
    
    $routes->get('view/(:any)', 'Admin\Device::view/$1');
});

$routes->group('data', ['filter' => 'group:admin, user'], static function ($routes) {
    $routes->get('/', 'Admin\Datadevice::index');
    $routes->post('ajax_dt', 'Admin\Datadevice::ajax_dt');

    $routes->group('', ['filter' => 'group:admin'], static function ($routes) {
        $routes->post('delete', 'Admin\Device::delete');
    });
});

$routes->group('users', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('/', 'Admin\Users::index');
    $routes->post('ajax_dt', 'Admin\Users::ajax_dt');
    $routes->get('add', 'Admin\Users::add');
    $routes->post('add_save', 'Admin\Users::add_save');
    $routes->get('view/(:any)', 'Admin\Users::view/$1');
    $routes->post('update', 'Admin\Users::update');
    $routes->post('delete', 'Admin\Users::delete');
});

$routes->group('profile', ['filter' => 'group:admin,user'], static function ($routes) {
    $routes->get('/', 'Profile::index');
    $routes->post('update', 'Profile::update');
});

$routes->group('realtime', ['filter' => 'group:admin,user'], static function ($routes) {
    $routes->get('/', 'Realtime::index');
    $routes->get('log', 'Realtime::log');
});

$routes->group('realtime', ['filter' => 'group:admin,user'], static function ($routes) {
    $routes->get('/', 'Realtime::index');
});

$routes->group('api', [], static function ($routes) {
    $routes->post('regis', 'Apidevice::regis');
    $routes->post('logging', 'Apidevice::logging');
});

service('auth')->routes($routes);
